<?php


namespace Toogas\Easypay\Api\Data;

interface EasypayApiTransactionInterface extends \Magento\Framework\Api\ExtensibleDataInterface
{

    const PAYMENT_ID = 'payment_id';
    const EASYPAYAPITRANSACTION_ID = 'easypayapitransaction_id';
    const UPDATED_AT = 'updated_at';
    const CREATED_AT = 'created_at';
    const ORIGIN = 'origin';
    const API_TRANSACTION_JSON = 'api_transaction_json';

    /**
     * Get easypayapitransaction_id
     * @return string|null
     */
    public function getEasypayapitransactionId();

    /**
     * Set easypayapitransaction_id
     * @param string $easypayapitransactionId
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setEasypayapitransactionId($easypayapitransactionId);

    /**
     * Get payment_id
     * @return string|null
     */
    public function getPaymentId();

    /**
     * Set payment_id
     * @param string $paymentId
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setPaymentId($paymentId);

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionExtensionInterface|null
     */
    public function getExtensionAttributes();

    /**
     * Set an extension attributes object.
     * @param \Toogas\Easypay\Api\Data\EasypayApiTransactionExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Toogas\Easypay\Api\Data\EasypayApiTransactionExtensionInterface $extensionAttributes
    );

    /**
     * Get origin
     * @return string|null
     */
    public function getOrigin();

    /**
     * Set origin
     * @param string $origin
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setOrigin($origin);

    /**
     * Get api_transaction_json
     * @return string|null
     */
    public function getApiTransactionJson();

    /**
     * Set api_transaction_json
     * @param string $apiTransactionJson
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setApiTransactionJson($apiTransactionJson);

    /**
     * Get created_at
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Set created_at
     * @param string $createdAt
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * Get updated_at
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Set updated_at
     * @param string $updatedAt
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setUpdatedAt($updatedAt);
}
