<?php


namespace Toogas\Easypay\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface EasypayApiTransactionRepositoryInterface
{

    /**
     * Save EasypayApiTransaction
     * @param \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface $easypayApiTransaction
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface $easypayApiTransaction
    );

    /**
     * Retrieve EasypayApiTransaction
     * @param string $easypayapitransactionId
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getById($easypayapitransactionId);

    /**
     * Retrieve EasypayApiTransaction matching the specified criteria.
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete EasypayApiTransaction
     * @param \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface $easypayApiTransaction
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface $easypayApiTransaction
    );

    /**
     * Delete EasypayApiTransaction by ID
     * @param string $easypayapitransactionId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($easypayapitransactionId);
}
