<?php


namespace Toogas\Easypay\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface EasypayPaymentRepositoryInterface
{

    /**
     * Save EasypayPayment
     * @param \Toogas\Easypay\Api\Data\EasypayPaymentInterface $easypayPayment
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \Toogas\Easypay\Api\Data\EasypayPaymentInterface $easypayPayment
    );

    /**
     * Retrieve EasypayPayment
     * @param string $easypaypaymentId
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getById($easypaypaymentId);

    /**
     * Retrieve EasypayPayment matching the specified criteria.
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete EasypayPayment
     * @param \Toogas\Easypay\Api\Data\EasypayPaymentInterface $easypayPayment
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \Toogas\Easypay\Api\Data\EasypayPaymentInterface $easypayPayment
    );

    /**
     * Delete EasypayPayment by ID
     * @param string $easypaypaymentId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($easypaypaymentId);
}
