<?php

namespace Toogas\Easypay\Block\Adminhtml\Payment;

use Magento\Framework\View\Element\Template;

class Info extends \Magento\Payment\Block\Info
{

    //protected $_template = 'Toogas_Easypay::payment/info.phtml';

    /** @var \Magento\Framework\Registry */
    protected $_registry;

    /** @var \Magento\Checkout\Model\Session */
    protected $_checkoutSession;

    public function __construct(
        Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Checkout\Model\Session $checkoutSession,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->_registry = $registry;
        $this->_checkoutSession = $checkoutSession;
    }

    protected function _prepareSpecificInformation($transport = null)
    {
        $transport = parent::_prepareSpecificInformation($transport);
        $payment = $this->getInfo();
        $paymentInfo = $payment->getAdditionalInformation('easypay');
        $checkoutData = $payment->getAdditionalInformation('checkout_data');
        $paymentInfoForward = $payment->getAdditionalInformation('easypay_forward');
        $info = [];
        switch ($payment->getMethod()) {
            case 'easypay_multibanco':
                $info = [
                    //'Transaction ID' => $paymentInfo['id'],
                    //'Payment Status' => ucfirst($paymentInfo['method']['status']),
                    'Entity' => $paymentInfo['method']['entity'],
                    'Reference' => chunk_split($paymentInfo['method']['reference'], 3, ' '),
                    'Ammount' => number_format($payment->getAmountOrdered(), 2, ',', '') . ' €',
                    'Valid Until' => $checkoutData['expiration_time'],
                ];
                break;
            case 'easypay_creditcard':
                $info = [
                    //'Transaction ID' => $paymentInfo['id'],
                    //'Payment Status' => ucfirst($paymentInfo['method']['status']),
                    //'Payment Url' => $paymentInfo['method']['url'],
                    'Ammount' => number_format($payment->getAmountOrdered(), 2, ',', '') . ' €',
                ];
                if ($paymentInfoForward && count($paymentInfoForward) > 0) {
                    //$info['Transaction Key'] = $paymentInfo['t_key'];
                    //$info['Payment Status'] = ucfirst($paymentInfoForward['s']);
                    //$info['Payment Entity'] = $paymentInfoForward['e'];
                    //$info['Payment Reference'] = $paymentInfoForward['r'];
                }
                break;
            case 'easypay_mbway':
                $info = [
                    //'Payment Status' => ucfirst($paymentInfo['method']['status']),
                    'Phone Number' => '(+351) ' . chunk_split($checkoutData['phone_number'], 3, ' '),
                    'Ammount' => number_format($payment->getAmountOrdered(), 2, ',', '') . ' €',
                ];
                break;
            default:
                $info = [
                    'Payment Status' => 'Pending',
                    'Ammount' => number_format($payment->getAmountOrdered(), 2, ',', '') . ' €',
                ];
        }
        return $transport->addData($info);
    }

    /**
     * @return \Magento\Payment\Model\InfoInterface|\Magento\Sales\Api\Data\OrderPaymentInterface|mixed|null
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getInfo()
    {
        /** @var \Magento\Sales\Model\Order $order */
        $order = $this->_registry->registry('current_order');
        return ($order === null) ? parent::getInfo() : $order->getPayment();
    }
}
