<?php

namespace Toogas\Easypay\Block\Checkout\Onepage;

use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Framework\Pricing\PriceCurrencyInterface;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Success extends Template
{

    /** @var CheckoutSession */
    protected $_checkoutSession;

    /** @var PriceCurrencyInterface */
    protected $_priceCurrency;

    public function __construct(
        Context $context,
        CheckoutSession $checkoutSession,
        PriceCurrencyInterface $priceCurrency,
        array $data = []
    ) {
        $this->_checkoutSession = $checkoutSession;
        $this->_priceCurrency = $priceCurrency;
        parent::__construct($context, $data);
    }

    public function getPaymentCode()
    {
        return $this->getOrder()->getPayment()->getMethodInstance()->getCode();
    }

    public function getOrder()
    {
        $order = $this->_checkoutSession->getLastRealOrder();
        return $order;
    }

    public function getPaymentInfo()
    {
        return $this->getOrder()->getPayment()->getAdditionalInformation();
    }

    /**
     * Get current currency symbol
     *
     * @return string
     */
    public function getCurrentCurrencySymbol()
    {
        return $this->_priceCurrency->getCurrency()->getCurrencySymbol();
    }
}
