<?php

namespace Toogas\Easypay\Controller\Adminhtml\EasypayPayment;

use Magento\Backend\App\Action;
use Magento\Framework\Session\SessionManagerInterface;
use Magento\Framework\View\Result\PageFactory;
use Toogas\Easypay\Api\EasypayPaymentRepositoryInterface;

class Edit extends \Magento\Backend\App\Action
{
    /**
     * PageFactory
     *
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * Easypay Payment Repository
     *
     * @var EasypayPaymentRepositoryInterface
     */
    protected $paymentsRepository;

    /**
     * Session
     *
     * @var SessionManagerInterface
     */
    protected $coreSession;

    /**
     * Edit constructor.
     *
     * @param Action\Context $context
     * @param PageFactory $resultPageFactory
     * @param EasypayPaymentRepositoryInterface $easypayPaymentRepository
     * @param SessionManagerInterface $session
     */
    public function __construct(
        Action\Context $context,
        PageFactory $resultPageFactory,
        EasypayPaymentRepositoryInterface $easypayPaymentRepository,
        SessionManagerInterface $session
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->paymentsRepository = $easypayPaymentRepository;
        $this->coreSession = $session;
        parent::__construct($context);
    }

    /**
     * Edit action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $ID = $this->getRequest()->getParam('payment_id');
        $model = null;
        if ($ID) {
            try {
                $model = $this->paymentsRepository->getById($ID);
            } catch (\Exception $e) {
                $this->messageManager->addErrorMessage(__('This Payment doesn\'t exist.'));
                /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();
                return $resultRedirect->setPath('*/*/');
            }
            $this->coreSession->setData('current_payment_id', $model->getPaymentId());
            if (!$model->getEasypaypaymentId()) {
                $this->messageManager->addErrorMessage(__('This Payment no longer exists.'));
                /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
                $resultRedirect = $this->resultRedirectFactory->create();
                return $resultRedirect->setPath('*/*/');
            }
        }
        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        if ($model) {
            $resultPage->getConfig()->getTitle()->prepend(__('Payment') . ' ' . $model->getPaymentId());
        } else {
            $resultPage->getConfig()->getTitle()->prepend(__('Payment'));
        }
        return $resultPage;
    }

}
