<?php

namespace Toogas\Easypay\Controller\Adminhtml\EasypayPayment;

use Magento\Backend\App\Action;
use Magento\Framework\App\ResponseInterface;

class FrequentCapture extends \Magento\Backend\App\Action
{
    /** @var \Toogas\Easypay\Model\EasypayPayment */
    protected $_easypayPaymentModel;

    /** @var \Toogas\Easypay\Model\Http\EasypayApi */
    protected $_easypayApi;

    /** @var \Magento\Sales\Model\Order */
    protected $_orderModel;

    /** @var \Magento\Sales\Model\Service\InvoiceService */
    protected $_invoiceService;

    /** @var \Magento\Framework\DB\Transaction */
    protected $_transaction;

    public function __construct(
        Action\Context $context,
        \Toogas\Easypay\Model\EasypayPayment $easypayPaymentModel,
        \Toogas\Easypay\Model\Http\EasypayApi $easypayApi,
        \Magento\Sales\Model\Order $orderModel,
        \Magento\Sales\Model\Service\InvoiceService $invoiceService,
        \Magento\Framework\DB\Transaction $transaction
    ) {
        parent::__construct($context);
        $this->_easypayPaymentModel = $easypayPaymentModel;
        $this->_easypayApi = $easypayApi;
        $this->_orderModel = $orderModel;
        $this->_invoiceService = $invoiceService;
        $this->_transaction = $transaction;
    }

    /**
     * Execute action based on request and return result
     *
     * Note: Request will be added as operation argument in future
     *
     * @return \Magento\Framework\Controller\ResultInterface|ResponseInterface
     * @throws \Magento\Framework\Exception\NotFoundException
     */
    public function execute()
    {
        $payment_id = $this->getRequest()->getParam('payment_id');
        if ($payment_id) {
            $easypayPayment = $this->_easypayPaymentModel->load($payment_id);
            if ($easypayPayment && $easypayPayment->getId()) {
                $order = $this->_orderModel->loadByIncrementId($easypayPayment->getOrderId());
                if ($order && $order->getId()) {
                    $result = $this->_easypayApi->requestPaymentCapture(
                        $easypayPayment->getPaymentId(),
                        $order->getGrandTotal()
                    );
                    if ($result) {
                        $this->invoice($order);
                        $this->messageManager->addSuccessMessage('Capture Request was successfully sent!');
                        return $this->_redirect($this->_redirect->getRefererUrl());
                    }
                }
            }
        }
        $this->messageManager->addErrorMessage('Capture Request failed!');
        return $this->_redirect($this->_redirect->getRefererUrl());
    }

    private function invoice($order) {
        $invoice = $this->_invoiceService->prepareInvoice($order);
        $invoice->register();
        $invoice->save();
        $transactionSave = $this->_transaction->addObject(
            $invoice
        )->addObject(
            $invoice->getOrder()
        );
        $transactionSave->save();
        $this->_invoiceService->notify($invoice->getId());
        $order
            ->addStatusHistoryComment(
                __('Notified customer about invoice #%1 created by a Successful Easypay Capture.', $invoice->getId())
            )
            ->setIsCustomerNotified(true)
            ->save();
    }

}
