<?php
/**
 * Created by PhpStorm.
 * User: toogas
 * Date: 25-03-2019
 * Time: 11:44
 */

namespace Toogas\Easypay\Controller\Adminhtml\EasypayPayment;

use Magento\Backend\App\Action;
use Magento\Framework\App\ResponseInterface;

class ManualCapture extends \Magento\Backend\App\Action
{
    /** @var \Toogas\Easypay\Model\EasypayPayment */
    protected $_easypayPaymentModel;

    /** @var \Toogas\Easypay\Model\Http\EasypayApi */
    protected $_easypayApi;

    /** @var \Magento\Sales\Model\Order */
    protected $_orderModel;

    public function __construct(
        Action\Context $context,
        \Toogas\Easypay\Model\EasypayPayment $easypayPaymentModel,
        \Toogas\Easypay\Model\Http\EasypayApi $easypayApi,
        \Magento\Sales\Model\Order $orderModel
    ) {
        parent::__construct($context);
        $this->_easypayPaymentModel = $easypayPaymentModel;
        $this->_easypayApi = $easypayApi;
        $this->_orderModel = $orderModel;
    }

    /**
     * Execute action based on request and return result
     *
     * Note: Request will be added as operation argument in future
     *
     * @return \Magento\Framework\Controller\ResultInterface|ResponseInterface
     * @throws \Magento\Framework\Exception\NotFoundException
     */
    public function execute()
    {
        $payment_id = $this->getRequest()->getParam('payment_id');
        if ($payment_id) {
            $easypayPayment = $this->_easypayPaymentModel->load($payment_id);
            if ($easypayPayment && $easypayPayment->getId()) {
                $order = $this->_orderModel->loadByIncrementId($easypayPayment->getOrderId());
                if ($order && $order->getId()) {
                    $result = $this->_easypayApi->requestPaymentCapture(
                        $easypayPayment->getPaymentId(),
                        $order->getGrandTotal()
                    );
                    if ($result) {
                        $this->messageManager->addSuccessMessage('Capture Request was successfully sent!');
                        return $this->_redirect($this->_redirect->getRefererUrl());
                    }
                }
            }
        }
        $this->messageManager->addErrorMessage('Capture Request failed!');
        return $this->_redirect($this->_redirect->getRefererUrl());
    }
}
