<?php

namespace Toogas\Easypay\Controller\Gateway;

use Magento\Framework\App\Action\Context;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;

class VisaDetail extends \Magento\Framework\App\Action\Action
{

    /** @var \Toogas\Easypay\Model\Http\EasypayApi */
    protected $_easypayApi;

    /** @var \Toogas\Easypay\Model\Config\EasypayConfig */
    protected $_easypayConfig;

    /** @var \Magento\Sales\Model\OrderRepository */
    protected $_orderRepository;

    /** @var \Magento\Sales\Model\OrderFactory */
    protected $_orderFactory;

    /** @var \Toogas\Easypay\Model\ResourceModel\EasypayPayment\CollectionFactory */
    protected $_easypayPaymentCollectionFactory;

    /** @var \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\CollectionFactory */
    protected $_easypayApiTransactionCollectionFactory;

    /** @var \Magento\Framework\Controller\Result\RawFactory */
    protected $_resultRawFactory;

    /**
     * VisaDetail constructor.
     * @param Context $context
     * @param \Toogas\Easypay\Model\Http\EasypayApi $easypayApi
     * @param \Toogas\Easypay\Model\Config\EasypayConfig $easypayConfig
     * @param \Magento\Sales\Model\OrderRepository $orderRepository
     * @param \Magento\Sales\Model\OrderFactory $orderFactory
     * @param \Toogas\Easypay\Model\ResourceModel\EasypayPayment\CollectionFactory $easypayPaymentCollectionFactory
     * @param \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\CollectionFactory $easypayApiTransactionCollectionFactory
     */
    public function __construct(
        Context $context,
        \Toogas\Easypay\Model\Http\EasypayApi $easypayApi,
        \Toogas\Easypay\Model\Config\EasypayConfig $easypayConfig,
        \Magento\Sales\Model\OrderRepository $orderRepository,
        \Magento\Sales\Model\OrderFactory $orderFactory,
        \Toogas\Easypay\Model\ResourceModel\EasypayPayment\CollectionFactory $easypayPaymentCollectionFactory,
        \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\CollectionFactory $easypayApiTransactionCollectionFactory,
        \Magento\Framework\Controller\Result\RawFactory $resultRawFactory
    ) {
        parent::__construct($context);
        $this->_easypayApi = $easypayApi;
        $this->_easypayConfig = $easypayConfig;
        $this->_orderRepository = $orderRepository;
        $this->_orderFactory = $orderFactory;
        $this->_easypayPaymentCollectionFactory = $easypayPaymentCollectionFactory;
        $this->_easypayApiTransactionCollectionFactory = $easypayApiTransactionCollectionFactory;
        $this->_resultRawFactory = $resultRawFactory;
    }

    public function execute()
    {
        $account_id = $this->_easypayConfig->getConfigure()['accountid'] ?? null;
        $request_id = $this->_request->getParam('id');
        $transaction_key = $this->_request->getParam('t_key');

        // Check if required params are present
        if (is_null($transaction_key) || is_null($request_id)) {
            echo "Error: Not enough params";
            exit();
        }

        // Check Easypay Account ID for security
        if ($account_id != $request_id) {
            echo "Error: Data mismatch";
            exit();
        }

        $entity = "";
        $reference = "";
        $value = "";

        $result = $this->_resultRawFactory->create();
        $result->setHeader('Content-Type', 'text/xml');

        // Build XML Output
        $xml = '<?xml version="1.0" ?>' . PHP_EOL; // encoding="ISO-8859-1"
        $xml .= '<get_detail>' . PHP_EOL;
        try {
            $easypayPaymentCollection = $this->_easypayPaymentCollectionFactory->create()->addFieldToFilter('payment_id', $transaction_key);
            if($easypayPaymentCollection->getSize() > 0) {
                $easypayPayment = $easypayPaymentCollection->getFirstItem();
                $order = $this->_orderFactory->create()->load($easypayPayment->getOrderId(), 'increment_id');

                $xml .= '<ep_status>' . 'ok' . '</ep_status>' . PHP_EOL;
                $xml .= '<ep_message>' . 'success' . '</ep_message>' . PHP_EOL;
                $xml .= '<ep_value>' . $value . '</ep_value>' . PHP_EOL;
                $xml .= '<t_key>' . $transaction_key . '</t_key>' . PHP_EOL;
                $xml .= '<order_info>' . PHP_EOL;
                    $xml .= '<total_taxes>' . $order->getTaxAmount() . '</total_taxes>' . PHP_EOL;
                    $xml .= '<total_including_taxes>' . $order->getGrandTotal() . '</total_including_taxes>' . PHP_EOL;
                    $xml .= '<bill_name>' . $order->getBillingAddress()->getFirstname() . ' ' . $order->getBillingAddress()->getLastname() . '</bill_name>' . PHP_EOL;
                    $xml .= '<bill_address_1>' . implode(' ', $order->getBillingAddress()->getStreet()) . '</bill_address_1>' . PHP_EOL;
                    //$xml .= '<bill_address_2>' . $order->getBillingAddress()->getStreet()[1] . '</bill_address_2>' . PHP_EOL;
                    $xml .= '<bill_city>' . $order->getBillingAddress()->getCity() . '</bill_city>' . PHP_EOL;
                    $xml .= '<bill_zip_code>' . $order->getBillingAddress()->getPostcode() . '</bill_zip_code>' . PHP_EOL;
                    $xml .= '<bill_country>' . $order->getBillingAddress()->getCountryId() . '</bill_country>' . PHP_EOL;
                    $xml .= '<shipp_name>' .  $order->getShippingAddress()->getFirstname() . ' ' . $order->getShippingAddress()->getLastname() . '</shipp_name>' . PHP_EOL;
                    $xml .= '<shipp_adress_1>' . implode(' ', $order->getShippingAddress()->getStreet()) . '</shipp_adress_1>' . PHP_EOL;
                    //$xml .= '<shipp_adress_2>' . $order->getShippingAddress()->getStreet()[1] . '</shipp_adress_2>' . PHP_EOL;
                    $xml .= '<shipp_city>' . $order->getShippingAddress()->getCity() . '</shipp_city>' . PHP_EOL;
                    $xml .= '<shipp_zip_code>' . $order->getShippingAddress()->getPostcode() . '</shipp_zip_code>' . PHP_EOL;
                    $xml .= '<shipp_country>' . $order->getShippingAddress()->getCountryId() . '</shipp_country>' . PHP_EOL;
                $xml .= '</order_info>' . PHP_EOL;
                $xml .= '<order_detail>' . PHP_EOL;
                foreach ($order->getAllVisibleItems() as $item) {
                    /** @var \Magento\Sales\Model\Order\Item $item */
                    $xml .= '<item>' . PHP_EOL;
                    $xml .= '<item_description>' . $item->getSku() . ' - ' . $item->getName() . '</item_description>' . PHP_EOL;
                    $xml .= '<item_quantity>' .  $item->getQtyOrdered() . '</item_quantity>' . PHP_EOL;
                    $xml .= '<item_total>' . $item->getPriceInclTax() . '</item_total>' . PHP_EOL;
                    $xml .= '</item>' . PHP_EOL;
                }
                $xml .= '</order_detail>' . PHP_EOL;
            }
            else {
                $xml.= '<ep_status>' . 'err' . '</ep_status>' . PHP_EOL;
                $xml.= '<ep_message>' . 'Transaction Key Não Reconhecida' . '</ep_message>' . PHP_EOL;
                $xml.= '<ep_entity>' . $entity . '</ep_entity>' . PHP_EOL;
                $xml.= '<ep_reference>' . $reference . '</ep_reference>' . PHP_EOL;
                $xml.= '<ep_value>' . $value . '</ep_value>' . PHP_EOL;
            }
        } catch (InputException $e) {
            $xml.= '<ep_status>' . 'err' . '</ep_status>' . PHP_EOL;
            $xml.= '<ep_message>' . $e->getMessage() . '</ep_message>' . PHP_EOL;
            $xml.= '<ep_entity>' . $entity . '</ep_entity>' . PHP_EOL;
            $xml.= '<ep_reference>' . $reference . '</ep_reference>' . PHP_EOL;
            $xml.= '<ep_value>' . $value . '</ep_value>' . PHP_EOL;
        } catch (NoSuchEntityException $e) {
            $xml.= '<ep_status>' . 'err' . '</ep_status>' . PHP_EOL;
            $xml.= '<ep_message>' . $e->getMessage() . '</ep_message>' . PHP_EOL;
            $xml.= '<ep_entity>' . $entity . '</ep_entity>' . PHP_EOL;
            $xml.= '<ep_reference>' . $reference . '</ep_reference>' . PHP_EOL;
            $xml.= '<ep_value>' . $value . '</ep_value>' . PHP_EOL;
        }
        $xml .= '</get_detail>' . PHP_EOL;

        $result->setContents($xml);
        return $result;
    }

}
