<?php

namespace Toogas\Easypay\Controller\Notification;

use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\ResponseInterface;

class Authorisation extends \Magento\Framework\App\Action\Action implements \Magento\Framework\App\Action\HttpPostActionInterface, \Magento\Framework\App\CsrfAwareActionInterface
{
    /** @var \Magento\Framework\Controller\Result\JsonFactory */
    protected $_resultJsonFactory;

    /** @var \Toogas\Easypay\Model\Config\EasypayConfig */
    protected $_easypayConfig;

    /** @var \Toogas\Easypay\Model\EasypayPayment */
    protected $_easypayPaymentModel;

    /** @var \Toogas\Easypay\Model\EasypayApiTransactionFactory */
    protected $_easypayApiTransactionFactory;

    /** @var \Magento\Sales\Model\Order */
    protected $_orderModel;

    /** @var \Magento\Sales\Model\Service\InvoiceService */
    protected $_invoiceService;

    /** @var \Magento\Framework\DB\Transaction */
    protected $_transaction;

    public function __construct(
        Context $context,
        \Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory,
        \Toogas\Easypay\Model\Config\EasypayConfig $easypayConfig,
        \Toogas\Easypay\Model\EasypayPayment $easypayPaymentModel,
        \Toogas\Easypay\Model\EasypayApiTransactionFactory $easypayApiTransactionFactory,
        \Magento\Sales\Model\Order $orderModel,
        \Magento\Sales\Model\Service\InvoiceService $invoiceService,
        \Magento\Framework\DB\Transaction $transaction
    ) {
        $this->_resultJsonFactory = $resultJsonFactory;
        $this->_easypayConfig = $easypayConfig;
        $this->_easypayPaymentModel = $easypayPaymentModel;
        $this->_easypayApiTransactionFactory = $easypayApiTransactionFactory;
        $this->_orderModel = $orderModel;
        $this->_invoiceService = $invoiceService;
        $this->_transaction = $transaction;
        parent::__construct($context);
    }

    /**
     * Execute action based on request and return result
     *
     * Note: Request will be added as operation argument in future
     *
     * @return \Magento\Framework\Controller\ResultInterface|ResponseInterface
     * @throws \Exception
     */
    public function execute()
    {
        $response = $this->_resultJsonFactory->create();
        $x_easypay_code = $this->_easypayConfig->getNotificationConfiguration('authorisation');
        if ($this->getRequest()->getHeader('x-easypay-code') === $x_easypay_code) {
            $data = json_decode($this->getRequest()->getContent(), true);
            if ($data && is_array($data) && count($data) > 0 && isset($data['id']) && $data['id'] !== '') {
                $payment = $this->_easypayPaymentModel->load($data['id'], 'payment_id');
                if ($payment && $payment->getId()) {
                    /** @var \Toogas\Easypay\Model\EasypayApiTransaction $apiTransaction */
                    $apiTransaction = $this->_easypayApiTransactionFactory->create();
                    $apiTransaction->setData([
                        'payment_id' => $data['id'],
                        'origin' => 'easypay',
                        'api_transaction_json' => json_encode($data, JSON_PRETTY_PRINT)
                    ]);
                    $apiTransaction->save();
                    $this->handleStatusChange($payment);
                    return $response->setData(['status' => 'ok', 'message' => 'Received Easypay API Data.']);
                }
                return $response->setData(['status' => 'error', 'message' => 'Could not find any payment with requested id.']);
            }
            return $response->setData(['status' => 'error', 'message' => 'Did not receive any data.']);
        }
        return $response->setData(['status' => 'error', 'message' => 'Invalid or Missing x-easypay-code Header']);
    }

    /**
     * @param \Toogas\Easypay\Model\EasypayPayment $payment
     * @throws \Exception
     */
    protected function handleStatusChange($payment)
    {
        $order = $this->_orderModel->loadByIncrementId($payment->getOrderId());
        if ($order->canInvoice() && $order->getState() === \Magento\Sales\Model\Order::STATE_NEW) {
            $order->setState(\Magento\Sales\Model\Order::STATE_PENDING_PAYMENT);
            $order->setStatus(\Magento\Sales\Model\Order::STATE_PENDING_PAYMENT);
        }
        $order->save();
    }

    /**
     * Create exception in case CSRF validation failed.
     * Return null if default exception will suffice.
     *
     * @param RequestInterface $request
     *
     * @return InvalidRequestException|null
     */
    public function createCsrfValidationException(RequestInterface $request): ?InvalidRequestException
    {
        return null;
    }

    /**
     * Perform custom request validation.
     * Return null if default validation is needed.
     *
     * @param RequestInterface $request
     *
     * @return bool|null
     */
    public function validateForCsrf(RequestInterface $request): ?bool
    {
        return true;
    }
}
