<?php

namespace Toogas\Easypay\Helper;

use Magento\Framework\App\Helper\Context;

class Http extends \Magento\Framework\App\Helper\AbstractHelper
{
    const CONNECTION_TIMEOUT  = 45;

    /** @var \Magento\Framework\HTTP\ZendClientFactory */
    protected $_httpClientFactory;

    /** @var \Magento\Framework\Xml\Security */
    protected $_xmlSecurityHelper;

    /**
     * Http constructor.
     * @param Context $context
     * @param \Magento\Framework\HTTP\ZendClientFactory $httpClientFactory
     * @param \Magento\Framework\Xml\Security $xmlSecurityHelper
     */
    public function __construct(
        Context $context,
        \Magento\Framework\HTTP\ZendClientFactory $httpClientFactory,
        \Magento\Framework\Xml\Security $xmlSecurityHelper
    ) {
        $this->_httpClientFactory = $httpClientFactory;
        $this->_xmlSecurityHelper = $xmlSecurityHelper;
        parent::__construct($context);
    }

    /**
     * @param $url
     * @param array $data
     * @param array $headers
     * @return \Zend_Http_Response
     * @throws \Zend_Http_Client_Exception
     */
    public function get($url, $data=[], $headers=[])
    {
        return $this->request($url, \Zend_Http_Client::GET, $data, $headers);
    }

    /**
     * @param $url
     * @param array $data
     * @param array $headers
     * @return \Zend_Http_Response
     * @throws \Zend_Http_Client_Exception
     */
    public function post($url, $data=[], $headers=[])
    {
        return $this->request($url, \Zend_Http_Client::POST, $data, $headers);
    }

    /**
     * @param $url
     * @param $method
     * @param array $data
     * @param array $headers
     * @return \Zend_Http_Response
     * @throws \Zend_Http_Client_Exception
     */
    public function request($url, $method, $data=[], $headers=[])
    {
        /** @var \Magento\Framework\HTTP\ZendClient $httpClient */
        $httpClient = $this->_httpClientFactory->create();
        $httpClient->setUri($url);
        $httpClient->setConfig(['timeout' => self::CONNECTION_TIMEOUT]);
        $httpClient->setHeaders($headers);
        $httpClient->setMethod($method);
        $httpClient->setRawData(json_encode($data));
        //$httpClient->setRawData($data);
        return $httpClient->request();
    }

    public function requestCurlPostJson($method, $url, $data=[], $headers=[])
    {
        $curlOpts = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTPHEADER => $headers,
        ];
        switch ($method) {
            case 'POST':
                $curlOpts[CURLOPT_POST] = 1;
                $curlOpts[CURLOPT_POSTFIELDS] = json_encode($data);
                break;
            case 'PATCH':
                $curlOpts[CURLOPT_CUSTOMREQUEST] = 'PATCH';
                $curlOpts[CURLOPT_POSTFIELDS] = json_encode($data);
                break;
            case 'DELETE':
                $curlOpts[CURLOPT_CUSTOMREQUEST] = 'DELETE';
                $curlOpts[CURLOPT_POSTFIELDS] = json_encode($data);
                break;
            default:
                $params = [];
                foreach ($data as $key=>$value) {
                    $params[] = $key . '=' . $value;
                }
                $curlOpts[CURLOPT_URL] = $url . '?' . implode('&', $params);
        }
        $curl = curl_init();
        curl_setopt_array($curl, $curlOpts);
        $writer = new \Zend\Log\Writer\Stream(BP . '/var/log/easypay-api-requests.log');
        $logger = new \Zend\Log\Logger();
        $logger->addWriter($writer);
        $logger->info('NEW REQUEST:');
        $logger->info('CALL: ' . $method . ' | ' . $url);
        $logger->info('HEADERS: ' . print_r($headers, true));
        $logger->info('DATA: ' . print_r($data, true));
        $response_body = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        $response = json_decode($response_body, true);
        $logger->info('RAW RESPONSE:' . $httpcode . ' | ' . PHP_EOL . print_r($response_body, true));
        $logger->info('RESPONSE:' . $httpcode . ' | ' . PHP_EOL . print_r($response, true));
        curl_close($curl);
        return $response;
    }
}
