<?php

namespace Toogas\Easypay\Model\Config;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\StoreManagerInterface;

class EasypayConfig
{
    const CONFIG_PATH               = 'payment/';
    const CONFIGURE_CONFIG_PATH     = self::CONFIG_PATH . 'easypay_configure';
    const MULTIBANCO_CONFIG_PATH    = self::CONFIG_PATH . 'easypay_multibanco';
    const MBWAY_CONFIG_PATH         = self::CONFIG_PATH . 'easypay_mbway';
    const CREDITCARD_CONFIG_PATH    = self::CONFIG_PATH . 'easypay_creditcard';
    const FREQUENT_CONFIG_PATH  = self::CONFIG_PATH . 'easypay_frequent';
    const BOLETO_CONFIG_PATH        = self::CONFIG_PATH . 'easypay_boleto';
    const NOTIFICATION_CONFIG_PATH  = self::CONFIG_PATH . 'easypay_notification';

    protected $_scopeConfig;
    protected $_storeManager;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        StoreManagerInterface $storeManager
    ) {
        $this->_scopeConfig = $scopeConfig;
        $this->_storeManager = $storeManager;
    }

    public function getConfigure()
    {
        return $this->_scopeConfig
                ->getValue(
                    self::CONFIGURE_CONFIG_PATH,
                    'store',
                    $this->_storeManager->getStore()->getCode()
                );
    }

    public function getMultibanco()
    {
        return $this->_scopeConfig
            ->getValue(
                self::MULTIBANCO_CONFIG_PATH,
                'store',
                $this->_storeManager->getStore()->getCode()
            );
    }

    public function getMbway()
    {
        return $this->_scopeConfig
            ->getValue(
                self::MBWAY_CONFIG_PATH,
                'store',
                $this->_storeManager->getStore()->getCode()
            );
    }

    public function getCreditCard()
    {
        return $this->_scopeConfig
            ->getValue(
                self::CREDITCARD_CONFIG_PATH,
                'store',
                $this->_storeManager->getStore()->getCode()
            );
    }

    public function getFrequent()
    {
        return $this->_scopeConfig
            ->getValue(
                self::FREQUENT_CONFIG_PATH,
                'store',
                $this->_storeManager->getStore()->getCode()
            );
    }

    public function getBoleto()
    {
        return $this->_scopeConfig
            ->getValue(
                self::BOLETO_CONFIG_PATH,
                'store',
                $this->_storeManager->getStore()->getCode()
            );
    }

    public function getNotificationConfiguration($key='')
    {
        return $this->_scopeConfig
            ->getValue(
                self::NOTIFICATION_CONFIG_PATH . '/' . $key,
                'store',
                $this->_storeManager->getStore()->getCode()
            );
    }
}
