<?php

namespace Toogas\Easypay\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;
use Toogas\Easypay\Model\EasypayConfigProvider;

class FrequentMethods implements ArrayInterface
{
    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach (EasypayConfigProvider::getAllSubscriptionMethods() as $code => $label) {
            $options[] = ['value' => $code, 'label' => __($label)];
        }
        return $options;
    }

}
