<?php

namespace Toogas\Easypay\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class PaymentType implements ArrayInterface
{
    const OPTION_AUTHORIZE = 'authorisation';
    const OPTION_AUTHORIZE_CAPTURE = 'sale';
    const OPTION_PURCHASE = 'sale';

    protected $_paymentTypes = [
        self::OPTION_AUTHORIZE => 'Authorize',
        //self::OPTION_PURCHASE => 'Purchase',
        self::OPTION_AUTHORIZE_CAPTURE => 'Authorize and Capture'
    ];

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->_paymentTypes as $code => $label) {
            $options[] = ['value' => $code, 'label' => __($label)];
        }
        return $options;
    }
}
