<?php

namespace Toogas\Easypay\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class Periodicity implements ArrayInterface
{

    const OPTION1D = '1D';         // Diário
    const OPTION1W = '1W';         // Weekly Semanal
    const OPTION2W = '2W';         // Semimonthly Quinzenal
    const OPTION1M = '1M';         // Monthly Mensal
    const OPTION2M = '2M';         // Bimonthly Bimestral
    const OPTION3M = '3M';         // Quaterly Trimestral
    const OPTION4M = '4M';         // Every 4 months Quadrimestral
    const OPTION6M = '6M';         // Semiannual Semestral
    const OPTION1Y = '1Y';         // Annual Anual

    protected $_periodicity = [
        self::OPTION2W => 'Semimonthly',
        self::OPTION1M => 'Monthly',
        self::OPTION2M => 'Bimonthly',
        self::OPTION3M => 'Quaterly',
        self::OPTION4M => 'Every 4 months',
        self::OPTION6M => 'Semiannual',
        self::OPTION1Y => 'Annual'
    ];

    /**
     * Return array of options as value-label pairs
     *
     * @return array Format: array(array('value' => '<value>', 'label' => '<label>'), ...)
     */
    public function toOptionArray()
    {
        $options = [];
        foreach ($this->_periodicity as $code => $label) {
            $options[] = ['value' => $code, 'label' => __($label)];
        }
        return $options;
    }
}
