<?php


namespace Toogas\Easypay\Model\Data;

use Toogas\Easypay\Api\Data\EasypayApiTransactionInterface;

class EasypayApiTransaction extends \Magento\Framework\Api\AbstractExtensibleObject implements EasypayApiTransactionInterface
{

    /**
     * Get easypayapitransaction_id
     * @return string|null
     */
    public function getEasypayapitransactionId()
    {
        return $this->_get(self::EASYPAYAPITRANSACTION_ID);
    }

    /**
     * Set easypayapitransaction_id
     * @param string $easypayapitransactionId
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setEasypayapitransactionId($easypayapitransactionId)
    {
        return $this->setData(self::EASYPAYAPITRANSACTION_ID, $easypayapitransactionId);
    }

    /**
     * Get payment_id
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->_get(self::PAYMENT_ID);
    }

    /**
     * Set payment_id
     * @param string $paymentId
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setPaymentId($paymentId)
    {
        return $this->setData(self::PAYMENT_ID, $paymentId);
    }

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->_getExtensionAttributes();
    }

    /**
     * Set an extension attributes object.
     * @param \Toogas\Easypay\Api\Data\EasypayApiTransactionExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Toogas\Easypay\Api\Data\EasypayApiTransactionExtensionInterface $extensionAttributes
    ) {
        return $this->_setExtensionAttributes($extensionAttributes);
    }

    /**
     * Get origin
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->_get(self::ORIGIN);
    }

    /**
     * Set origin
     * @param string $origin
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setOrigin($origin)
    {
        return $this->setData(self::ORIGIN, $origin);
    }

    /**
     * Get api_transaction_json
     * @return string|null
     */
    public function getApiTransactionJson()
    {
        return $this->_get(self::API_TRANSACTION_JSON);
    }

    /**
     * Set api_transaction_json
     * @param string $apiTransactionJson
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setApiTransactionJson($apiTransactionJson)
    {
        return $this->setData(self::API_TRANSACTION_JSON, $apiTransactionJson);
    }

    /**
     * Get created_at
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->_get(self::CREATED_AT);
    }

    /**
     * Set created_at
     * @param string $createdAt
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get updated_at
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->_get(self::UPDATED_AT);
    }

    /**
     * Set updated_at
     * @param string $updatedAt
     * @return \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }
}
