<?php


namespace Toogas\Easypay\Model\Data;

use Toogas\Easypay\Api\Data\EasypayPaymentInterface;

class EasypayPayment extends \Magento\Framework\Api\AbstractExtensibleObject implements EasypayPaymentInterface
{

    /**
     * Get easypaypayment_id
     * @return string|null
     */
    public function getEasypaypaymentId()
    {
        return $this->_get(self::EASYPAYPAYMENT_ID);
    }

    /**
     * Set easypaypayment_id
     * @param string $easypaypaymentId
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setEasypaypaymentId($easypaypaymentId)
    {
        return $this->setData(self::EASYPAYPAYMENT_ID, $easypaypaymentId);
    }

    /**
     * Get order_id
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->_get(self::ORDER_ID);
    }

    /**
     * Set order_id
     * @param string $orderId
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->_getExtensionAttributes();
    }

    /**
     * Set an extension attributes object.
     * @param \Toogas\Easypay\Api\Data\EasypayPaymentExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        \Toogas\Easypay\Api\Data\EasypayPaymentExtensionInterface $extensionAttributes
    ) {
        return $this->_setExtensionAttributes($extensionAttributes);
    }

    /**
     * Get payment_id
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->_get(self::PAYMENT_ID);
    }

    /**
     * Set payment_id
     * @param string $paymentId
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setPaymentId($paymentId)
    {
        return $this->setData(self::PAYMENT_ID, $paymentId);
    }

    /**
     * Get type
     * @return string|null
     */
    public function getType()
    {
        return $this->_get(self::TYPE);
    }

    /**
     * Set type
     * @param string $type
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setType($type)
    {
        return $this->setData(self::TYPE, $type);
    }

    /**
     * Get method
     * @return string|null
     */
    public function getMethod()
    {
        return $this->_get(self::METHOD);
    }

    /**
     * Set method
     * @param string $method
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setMethod($method)
    {
        return $this->setData(self::METHOD, $method);
    }

    /**
     * Get status
     * @return string|null
     */
    public function getStatus()
    {
        return $this->_get(self::STATUS);
    }

    /**
     * Set status
     * @param string $status
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get created_at
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->_get(self::CREATED_AT);
    }

    /**
     * Set created_at
     * @param string $createdAt
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get updated_at
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->_get(self::UPDATED_AT);
    }

    /**
     * Set updated_at
     * @param string $updatedAt
     * @return \Toogas\Easypay\Api\Data\EasypayPaymentInterface
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }
}
