<?php


namespace Toogas\Easypay\Model;

use Magento\Framework\Api\DataObjectHelper;
use Toogas\Easypay\Api\Data\EasypayApiTransactionInterface;
use Toogas\Easypay\Api\Data\EasypayApiTransactionInterfaceFactory;

class EasypayApiTransaction extends \Magento\Framework\Model\AbstractModel
{

    protected $_eventPrefix = 'toogas_easypay_easypayapitransaction';
    protected $easypayapitransactionDataFactory;

    protected $dataObjectHelper;


    /**
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param EasypayApiTransactionInterfaceFactory $easypayapitransactionDataFactory
     * @param DataObjectHelper $dataObjectHelper
     * @param \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction $resource
     * @param \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\Collection $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        EasypayApiTransactionInterfaceFactory $easypayapitransactionDataFactory,
        DataObjectHelper $dataObjectHelper,
        \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction $resource,
        \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\Collection $resourceCollection,
        array $data = []
    ) {
        $this->easypayapitransactionDataFactory = $easypayapitransactionDataFactory;
        $this->dataObjectHelper = $dataObjectHelper;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * Retrieve easypayapitransaction model with easypayapitransaction data
     * @return EasypayApiTransactionInterface
     */
    public function getDataModel()
    {
        $easypayapitransactionData = $this->getData();
        
        $easypayapitransactionDataObject = $this->easypayapitransactionDataFactory->create();
        $this->dataObjectHelper->populateWithArray(
            $easypayapitransactionDataObject,
            $easypayapitransactionData,
            EasypayApiTransactionInterface::class
        );
        
        return $easypayapitransactionDataObject;
    }
}
