<?php


namespace Toogas\Easypay\Model;

use Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction as ResourceEasypayApiTransaction;
use Magento\Framework\Reflection\DataObjectProcessor;
use Toogas\Easypay\Api\Data\EasypayApiTransactionInterfaceFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\CollectionFactory as EasypayApiTransactionCollectionFactory;
use Toogas\Easypay\Api\Data\EasypayApiTransactionSearchResultsInterfaceFactory;
use Toogas\Easypay\Api\EasypayApiTransactionRepositoryInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\Api\ExtensionAttribute\JoinProcessorInterface;
use Magento\Framework\Api\ExtensibleDataObjectConverter;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;

class EasypayApiTransactionRepository implements EasypayApiTransactionRepositoryInterface
{

    protected $dataEasypayApiTransactionFactory;

    protected $dataObjectHelper;

    private $collectionProcessor;

    protected $easypayApiTransactionFactory;

    protected $dataObjectProcessor;

    protected $resource;

    protected $extensibleDataObjectConverter;
    protected $searchResultsFactory;

    protected $extensionAttributesJoinProcessor;

    private $storeManager;

    protected $easypayApiTransactionCollectionFactory;


    /**
     * @param ResourceEasypayApiTransaction $resource
     * @param EasypayApiTransactionFactory $easypayApiTransactionFactory
     * @param EasypayApiTransactionInterfaceFactory $dataEasypayApiTransactionFactory
     * @param EasypayApiTransactionCollectionFactory $easypayApiTransactionCollectionFactory
     * @param EasypayApiTransactionSearchResultsInterfaceFactory $searchResultsFactory
     * @param DataObjectHelper $dataObjectHelper
     * @param DataObjectProcessor $dataObjectProcessor
     * @param StoreManagerInterface $storeManager
     * @param CollectionProcessorInterface $collectionProcessor
     * @param JoinProcessorInterface $extensionAttributesJoinProcessor
     * @param ExtensibleDataObjectConverter $extensibleDataObjectConverter
     */
    public function __construct(
        ResourceEasypayApiTransaction $resource,
        EasypayApiTransactionFactory $easypayApiTransactionFactory,
        EasypayApiTransactionInterfaceFactory $dataEasypayApiTransactionFactory,
        EasypayApiTransactionCollectionFactory $easypayApiTransactionCollectionFactory,
        EasypayApiTransactionSearchResultsInterfaceFactory $searchResultsFactory,
        DataObjectHelper $dataObjectHelper,
        DataObjectProcessor $dataObjectProcessor,
        StoreManagerInterface $storeManager,
        CollectionProcessorInterface $collectionProcessor,
        JoinProcessorInterface $extensionAttributesJoinProcessor,
        ExtensibleDataObjectConverter $extensibleDataObjectConverter
    ) {
        $this->resource = $resource;
        $this->easypayApiTransactionFactory = $easypayApiTransactionFactory;
        $this->easypayApiTransactionCollectionFactory = $easypayApiTransactionCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->dataObjectHelper = $dataObjectHelper;
        $this->dataEasypayApiTransactionFactory = $dataEasypayApiTransactionFactory;
        $this->dataObjectProcessor = $dataObjectProcessor;
        $this->storeManager = $storeManager;
        $this->collectionProcessor = $collectionProcessor;
        $this->extensionAttributesJoinProcessor = $extensionAttributesJoinProcessor;
        $this->extensibleDataObjectConverter = $extensibleDataObjectConverter;
    }

    /**
     * {@inheritdoc}
     */
    public function save(
        \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface $easypayApiTransaction
    ) {
        /* if (empty($easypayApiTransaction->getStoreId())) {
            $storeId = $this->storeManager->getStore()->getId();
            $easypayApiTransaction->setStoreId($storeId);
        } */
        
        $easypayApiTransactionData = $this->extensibleDataObjectConverter->toNestedArray(
            $easypayApiTransaction,
            [],
            \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface::class
        );
        
        $easypayApiTransactionModel = $this->easypayApiTransactionFactory->create()->setData($easypayApiTransactionData);
        
        try {
            $this->resource->save($easypayApiTransactionModel);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the easypayApiTransaction: %1',
                $exception->getMessage()
            ));
        }
        return $easypayApiTransactionModel->getDataModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getById($easypayApiTransactionId)
    {
        $easypayApiTransaction = $this->easypayApiTransactionFactory->create();
        $this->resource->load($easypayApiTransaction, $easypayApiTransactionId);
        if (!$easypayApiTransaction->getId()) {
            throw new NoSuchEntityException(__('EasypayApiTransaction with id "%1" does not exist.', $easypayApiTransactionId));
        }
        return $easypayApiTransaction->getDataModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $criteria
    ) {
        $collection = $this->easypayApiTransactionCollectionFactory->create();
        
        $this->extensionAttributesJoinProcessor->process(
            $collection,
            \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface::class
        );
        
        $this->collectionProcessor->process($criteria, $collection);
        
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        
        $items = [];
        foreach ($collection as $model) {
            $items[] = $model->getDataModel();
        }
        
        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * {@inheritdoc}
     */
    public function delete(
        \Toogas\Easypay\Api\Data\EasypayApiTransactionInterface $easypayApiTransaction
    ) {
        try {
            $easypayApiTransactionModel = $this->easypayApiTransactionFactory->create();
            $this->resource->load($easypayApiTransactionModel, $easypayApiTransaction->getEasypayapitransactionId());
            $this->resource->delete($easypayApiTransactionModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the EasypayApiTransaction: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function deleteById($easypayApiTransactionId)
    {
        return $this->delete($this->getById($easypayApiTransactionId));
    }
}
