<?php
/**
 * Created by PhpStorm.
 * User: toogas
 * Date: 05-03-2019
 * Time: 16:07
 */

namespace Toogas\Easypay\Model;

use Magento\Framework\App\Config\ScopeConfigInterface;

class EasypayConfigProvider implements \Magento\Checkout\Model\ConfigProviderInterface
{
    const XML_CONFIG_SUBSCRIPTION_TYPE_METHODS = 'payment/easypay_frequent/methods';

    /** @var string[] */
    protected $methodCodes = [
        'easypay_multibanco',
        'easypay_creditcard',
        'easypay_frequent',
        'easypay_mbway',
        'easypay_boleto'
    ];

    /** @var string[] */
    protected $methodCodesToImageName = [
        'easypay_multibanco' => 'mb',
        'easypay_creditcard' => 'cc',
        'easypay_mbway' => 'mbw',
        'easypay_boleto' => 'bb',
        'easypay_frequent' => 'fq'
    ];

    /** @var \Magento\Payment\Model\Method\AbstractMethod[] */
    protected $methods = [];

    /** @var \Magento\Payment\Helper\Data */
    protected $_paymentHelper;

    /** @var ScopeConfigInterface */
    protected $scopeConfig;

    /** @var \Magento\Framework\View\Asset\Repository */
    protected $_assetRepository;

    /**
     * EasypayConfigProvider constructor.
     *
     * @param \Magento\Payment\Helper\Data $paymentHelper
     * @param ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\View\Asset\Repository $assetRepository
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function __construct(
        \Magento\Payment\Helper\Data $paymentHelper,
        ScopeConfigInterface $scopeConfig,
        \Magento\Framework\View\Asset\Repository $assetRepository
    ) {
        $this->_paymentHelper = $paymentHelper;
        $this->_assetRepository = $assetRepository;
        foreach ($this->methodCodes as $methodCode) {
            $this->methods[$methodCode] = $this->_paymentHelper->getMethodInstance($methodCode);
        }
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Retrieve assoc array of checkout configuration
     *
     * @return array
     */
    public function getConfig()
    {
        $config = [];
        foreach ($this->methodCodes as $code) {
            if ($this->methods[$code]->isAvailable()) {
                $config['payment']['instructions'][$code] = $this->methods[$code]->getData('instructions');
                $config['payment']['images'][$code] = $this->_assetRepository->getUrl('Toogas_Easypay::images/' . $this->methodCodesToImageName[$code] . '.png');
            }
        }
        $config['payment']['subscriptions']['list'] = $this->buildSubscriptionMethods();
        return $config;
    }

    /**
     * Return all the possible methods that the subscription global method supports
     *
     * @return array
     */
    final public static function getAllSubscriptionMethods()
    {
        return [
            'mb'    => __('Multibanco'),
            'mbw'   => __('MBWay'),
            'cc'    => __('Credit Card'),
            'dd'    => __('Direct Debit')
        ];
    }

    /**
     * Returns the methods avaiable in the subscriptions configuration
     *
     * @return array
     */
    private function buildSubscriptionMethods()
    {
        $subscriptionMethods = [];
        $allMethods = self::getAllSubscriptionMethods();
        $storedMethods = $this->scopeConfig->getValue(
            self::XML_CONFIG_SUBSCRIPTION_TYPE_METHODS,
            'store'
        );
        $storedMethods = explode(',', $storedMethods);
        if (!empty($storedMethods)) {
            foreach ($storedMethods as $storedMethod) {
                if (isset($allMethods[$storedMethod])) {
                    $subscriptionMethods[] =
                        [
                            'code' => $storedMethod,
                            'label' => $allMethods[$storedMethod]
                        ];
                }
            }
        }
        return $subscriptionMethods;
    }
}
