<?php


namespace Toogas\Easypay\Model;

use Magento\Framework\Api\DataObjectHelper;
use Toogas\Easypay\Api\Data\EasypayPaymentInterfaceFactory;
use Toogas\Easypay\Api\Data\EasypayPaymentInterface;

class EasypayPayment extends \Magento\Framework\Model\AbstractModel
{

    protected $_eventPrefix = 'toogas_easypay_easypaypayment';
    protected $easypaypaymentDataFactory;

    protected $dataObjectHelper;


    /**
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param EasypayPaymentInterfaceFactory $easypaypaymentDataFactory
     * @param DataObjectHelper $dataObjectHelper
     * @param \Toogas\Easypay\Model\ResourceModel\EasypayPayment $resource
     * @param \Toogas\Easypay\Model\ResourceModel\EasypayPayment\Collection $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        EasypayPaymentInterfaceFactory $easypaypaymentDataFactory,
        DataObjectHelper $dataObjectHelper,
        \Toogas\Easypay\Model\ResourceModel\EasypayPayment $resource,
        \Toogas\Easypay\Model\ResourceModel\EasypayPayment\Collection $resourceCollection,
        array $data = []
    ) {
        $this->easypaypaymentDataFactory = $easypaypaymentDataFactory;
        $this->dataObjectHelper = $dataObjectHelper;
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * Retrieve easypaypayment model with easypaypayment data
     * @return EasypayPaymentInterface
     */
    public function getDataModel()
    {
        $easypaypaymentData = $this->getData();
        
        $easypaypaymentDataObject = $this->easypaypaymentDataFactory->create();
        $this->dataObjectHelper->populateWithArray(
            $easypaypaymentDataObject,
            $easypaypaymentData,
            EasypayPaymentInterface::class
        );
        
        return $easypaypaymentDataObject;
    }
}
