<?php


namespace Toogas\Easypay\Model;

use Toogas\Easypay\Api\Data\EasypayPaymentSearchResultsInterfaceFactory;
use Magento\Framework\Reflection\DataObjectProcessor;
use Toogas\Easypay\Model\ResourceModel\EasypayPayment as ResourceEasypayPayment;
use Magento\Framework\Exception\NoSuchEntityException;
use Toogas\Easypay\Model\ResourceModel\EasypayPayment\CollectionFactory as EasypayPaymentCollectionFactory;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Toogas\Easypay\Api\Data\EasypayPaymentInterfaceFactory;
use Toogas\Easypay\Api\EasypayPaymentRepositoryInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Api\DataObjectHelper;
use Magento\Framework\Api\ExtensionAttribute\JoinProcessorInterface;
use Magento\Framework\Api\ExtensibleDataObjectConverter;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;

class EasypayPaymentRepository implements EasypayPaymentRepositoryInterface
{

    protected $dataObjectHelper;

    private $collectionProcessor;

    protected $dataObjectProcessor;

    protected $resource;

    protected $dataEasypayPaymentFactory;

    protected $easypayPaymentCollectionFactory;

    protected $extensibleDataObjectConverter;
    protected $searchResultsFactory;

    protected $easypayPaymentFactory;

    protected $extensionAttributesJoinProcessor;

    private $storeManager;


    /**
     * @param ResourceEasypayPayment $resource
     * @param EasypayPaymentFactory $easypayPaymentFactory
     * @param EasypayPaymentInterfaceFactory $dataEasypayPaymentFactory
     * @param EasypayPaymentCollectionFactory $easypayPaymentCollectionFactory
     * @param EasypayPaymentSearchResultsInterfaceFactory $searchResultsFactory
     * @param DataObjectHelper $dataObjectHelper
     * @param DataObjectProcessor $dataObjectProcessor
     * @param StoreManagerInterface $storeManager
     * @param CollectionProcessorInterface $collectionProcessor
     * @param JoinProcessorInterface $extensionAttributesJoinProcessor
     * @param ExtensibleDataObjectConverter $extensibleDataObjectConverter
     */
    public function __construct(
        ResourceEasypayPayment $resource,
        EasypayPaymentFactory $easypayPaymentFactory,
        EasypayPaymentInterfaceFactory $dataEasypayPaymentFactory,
        EasypayPaymentCollectionFactory $easypayPaymentCollectionFactory,
        EasypayPaymentSearchResultsInterfaceFactory $searchResultsFactory,
        DataObjectHelper $dataObjectHelper,
        DataObjectProcessor $dataObjectProcessor,
        StoreManagerInterface $storeManager,
        CollectionProcessorInterface $collectionProcessor,
        JoinProcessorInterface $extensionAttributesJoinProcessor,
        ExtensibleDataObjectConverter $extensibleDataObjectConverter
    ) {
        $this->resource = $resource;
        $this->easypayPaymentFactory = $easypayPaymentFactory;
        $this->easypayPaymentCollectionFactory = $easypayPaymentCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->dataObjectHelper = $dataObjectHelper;
        $this->dataEasypayPaymentFactory = $dataEasypayPaymentFactory;
        $this->dataObjectProcessor = $dataObjectProcessor;
        $this->storeManager = $storeManager;
        $this->collectionProcessor = $collectionProcessor;
        $this->extensionAttributesJoinProcessor = $extensionAttributesJoinProcessor;
        $this->extensibleDataObjectConverter = $extensibleDataObjectConverter;
    }

    /**
     * {@inheritdoc}
     */
    public function save(
        \Toogas\Easypay\Api\Data\EasypayPaymentInterface $easypayPayment
    ) {
        /* if (empty($easypayPayment->getStoreId())) {
            $storeId = $this->storeManager->getStore()->getId();
            $easypayPayment->setStoreId($storeId);
        } */
        
        $easypayPaymentData = $this->extensibleDataObjectConverter->toNestedArray(
            $easypayPayment,
            [],
            \Toogas\Easypay\Api\Data\EasypayPaymentInterface::class
        );
        
        $easypayPaymentModel = $this->easypayPaymentFactory->create()->setData($easypayPaymentData);
        
        try {
            $this->resource->save($easypayPaymentModel);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the easypayPayment: %1',
                $exception->getMessage()
            ));
        }
        return $easypayPaymentModel->getDataModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getById($easypayPaymentId)
    {
        $easypayPayment = $this->easypayPaymentFactory->create();
        $this->resource->load($easypayPayment, $easypayPaymentId);
        if (!$easypayPayment->getId()) {
            throw new NoSuchEntityException(__('EasypayPayment with id "%1" does not exist.', $easypayPaymentId));
        }
        return $easypayPayment->getDataModel();
    }

    /**
     * {@inheritdoc}
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $criteria
    ) {
        $collection = $this->easypayPaymentCollectionFactory->create();
        
        $this->extensionAttributesJoinProcessor->process(
            $collection,
            \Toogas\Easypay\Api\Data\EasypayPaymentInterface::class
        );
        
        $this->collectionProcessor->process($criteria, $collection);
        
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        
        $items = [];
        foreach ($collection as $model) {
            $items[] = $model->getDataModel();
        }
        
        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * {@inheritdoc}
     */
    public function delete(
        \Toogas\Easypay\Api\Data\EasypayPaymentInterface $easypayPayment
    ) {
        try {
            $easypayPaymentModel = $this->easypayPaymentFactory->create();
            $this->resource->load($easypayPaymentModel, $easypayPayment->getEasypaypaymentId());
            $this->resource->delete($easypayPaymentModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the EasypayPayment: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function deleteById($easypayPaymentId)
    {
        return $this->delete($this->getById($easypayPaymentId));
    }
}
