<?php

namespace Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction\Grid;

use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult;
use Psr\Log\LoggerInterface as Logger;

class Collection extends SearchResult
{
    /** @var \Magento\Framework\Session\SessionManagerInterface */
    protected $coreSession;

    /**
     * Collection constructor.
     * @param EntityFactory $entityFactory
     * @param Logger $logger
     * @param FetchStrategy $fetchStrategy
     * @param EventManager $eventManager
     * @param \Magento\Framework\Session\SessionManagerInterface $coreSession
     * @param string $mainTable
     * @param string $resourceModel
     * @param string|null $identifierName
     * @param string|null $connectionName
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function __construct(
        EntityFactory $entityFactory,
        Logger $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager,
        \Magento\Framework\Session\SessionManagerInterface $coreSession,
        string $mainTable = "toogas_easypay_easypayapitransaction",
        string $resourceModel = \Toogas\Easypay\Model\ResourceModel\EasypayApiTransaction::class,
        string $identifierName = null,
        string $connectionName = null
    ) {
        $this->coreSession = $coreSession;
        parent::__construct(
            $entityFactory,
            $logger,
            $fetchStrategy,
            $eventManager,
            $mainTable,
            $resourceModel,
            $identifierName,
            $connectionName
        );
    }

    /**
     * @return $this
     */
    protected function _initSelect()
    {
        parent::_initSelect();
        $id = $this->coreSession->getData('current_payment_id');
        if ($id) {
            $this->addFieldToFilter('payment_id', ['EQ' => $id]);
        }
        return $this;
    }

}
