<?php

namespace Toogas\Easypay\Plugin\Magento\Sales\Block\Adminhtml\Order;

class View
{
    /** @var \Magento\Framework\UrlInterface */
    protected $_urlBuilder;

    /** @var \Toogas\Easypay\Model\EasypayPayment */
    protected $_easypayPayment;

    public function __construct(
        \Magento\Framework\UrlInterface $urlBuilder,
        \Toogas\Easypay\Model\EasypayPayment $easypayPayment
    ) {
        $this->_urlBuilder = $urlBuilder;
        $this->_easypayPayment = $easypayPayment;
    }

    public function beforeSetLayout(\Magento\Sales\Block\Adminhtml\Order\View $view)
    {
        $payment = $this->_easypayPayment->load($view->getOrder()->getIncrementId(), 'order_id');
        if ($payment && $payment->getId() && strpos($payment->getMethod(), 'fq-') === 0) {
            $message = __('Are you sure you want to capture this frequent?');
            $url = $this->_urlBuilder->getUrl(
                'toogas_easypay/easypaypayment/frequentcapture',
                [ 'payment_id' => $payment->getId() ]
            );
            $view->addButton(
                'easypay_capture_frequent',
                [
                    'label' => __('Easypay - Frequent Capture'),
                    'class' => 'primary',
                    'onclick' => "confirmSetLocation('{$message}', '{$url}')"
                ]
            );
        }

        if ($payment && $payment->getId() && $payment->getType() === 'authorisation' && $payment->getStatus() === 'authorized') {
            $message = __('Are you sure you want to capture and invoice?');
            $url = $this->_urlBuilder->getUrl(
                'toogas_easypay/easypaypayment/manualcapture',
                [ 'payment_id' => $payment->getId() ]
            );
            $view->addButton(
                'easypay_capture_invoice',
                [
                    'label' => __('Easypay - Capture and Invoice'),
                    'class' => 'primary',
                    'onclick' => "confirmSetLocation('{$message}', '{$url}')"
                ]
            );
        }
    }
}
