<?php

namespace Toogas\Easypay\Setup;

use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class InstallSchema implements InstallSchemaInterface
{

    /**
     * {@inheritdoc}
     */
    public function install(
        SchemaSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $table_toogas_easypay_easypayapitransaction = $setup->getConnection()->newTable($setup->getTable('toogas_easypay_easypayapitransaction'));

        $table_toogas_easypay_easypayapitransaction->addColumn(
            'easypayapitransaction_id',
            \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
            null,
            ['identity' => true,'nullable' => false,'primary' => true,'unsigned' => true],
            'Entity ID'
        );

        $table_toogas_easypay_easypayapitransaction->addColumn(
            'payment_id',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            255,
            [],
            'payment_id'
        );

        $table_toogas_easypay_easypayapitransaction->addColumn(
            'origin',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            255,
            [],
            'origin'
        );

        $table_toogas_easypay_easypayapitransaction->addColumn(
            'api_transaction_json',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            null,
            [],
            'api_transaction_json'
        );

        $table_toogas_easypay_easypaypayment = $setup->getConnection()->newTable($setup->getTable('toogas_easypay_easypaypayment'));

        $table_toogas_easypay_easypaypayment->addColumn(
            'easypaypayment_id',
            \Magento\Framework\DB\Ddl\Table::TYPE_INTEGER,
            null,
            ['identity' => true,'nullable' => false,'primary' => true,'unsigned' => true],
            'Entity ID'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'order_id',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            255,
            [],
            'order_id'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'payment_id',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            255,
            [],
            'payment_id'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'type',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            null,
            [],
            'type'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'method',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            null,
            [],
            'method'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'status',
            \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            null,
            [],
            'status'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'created_at',
            \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
            null,
            ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
            'created_at'
        );

        $table_toogas_easypay_easypaypayment->addColumn(
            'updated_at',
            \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
            null,
            ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
            'updated_at'
        );

        $table_toogas_easypay_easypayapitransaction->addColumn(
            'created_at',
            \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
            null,
            ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT],
            'created_at'
        );

        $table_toogas_easypay_easypayapitransaction->addColumn(
            'updated_at',
            \Magento\Framework\DB\Ddl\Table::TYPE_TIMESTAMP,
            null,
            ['nullable' => false, 'default' => \Magento\Framework\DB\Ddl\Table::TIMESTAMP_INIT_UPDATE],
            'updated_at'
        );

        $setup->getConnection()->createTable($table_toogas_easypay_easypaypayment);

        $setup->getConnection()->createTable($table_toogas_easypay_easypayapitransaction);
    }
}
