<?php

namespace Toogas\Easypay\Setup;

use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\UpgradeDataInterface;

/**
 * Class InstallData
 * @package Magento\TestSetupDeclarationModule3\Setup
 */
class UpgradeData implements UpgradeDataInterface
{

    /** @var \Magento\Framework\App\Config\Storage\WriterInterface */
    private $configWriter;

    /** @var \Magento\Store\Model\StoreManagerInterface */
    private $storeManager;


    /**
     * UpgradeData constructor.
     * @param \Magento\Framework\App\Config\Storage\WriterInterface $configWriter
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        \Magento\Framework\App\Config\Storage\WriterInterface  $configWriter,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->configWriter = $configWriter;
        $this->storeManager = $storeManager;
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     * @SuppressWarnings(PHPMD.NPathComplexity)
     */
    public function upgrade(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $adapter = $setup->getConnection();
        $setup->startSetup();

        if (version_compare($context->getVersion(), '1.0.1') < 0) {
            $base_url = $this->storeManager->getDefaultStoreView()->getBaseUrl();
            $this->configWriter->save(
                'payment/easypay_info/url_visa_forward',
                $base_url . 'easypay/gateway/creditcard'
            );
            $this->configWriter->save(
                'payment/easypay_info/url_boleto_forward',
                $base_url . 'easypay/gateway/boletobancario'
            );
            $this->configWriter->save(
                'payment/easypay_info/url_callback_generic',
                $base_url . 'easypay/notification/generic'
            );
            $this->configWriter->save(
                'payment/easypay_info/url_callback_payment',
                $base_url . 'easypay/notification/transaction'
            );
            $this->configWriter->save(
                'payment/easypay_info/url_callback_authorisation',
                $base_url . 'easypay/notification/authorisation'
            );
            $this->configWriter->save(
                'payment/easypay_info/url_visa_detail',
                $base_url . 'easypay/gateway/visadetail'
            );
        }

        $setup->endSetup();
    }
}
