<?php

namespace Toogas\Easypay\Ui\Component\Listing\Column\Payment;

class Method extends \Magento\Ui\Component\Listing\Columns\Column
{
    /**
     * @inheritdoc
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                if (isset($item['method'])) {
                    switch ($item['method']) {
                        case 'mb':
                            $correctMethod = __('Multibanco');
                            break;
                        case 'cc':
                            $correctMethod = __('Credit Card');
                            break;
                        case 'dd':
                            $correctMethod = __('Direct Debit');
                            break;
                        case 'mbw':
                            $correctMethod = __('MBWay');
                            break;
                        default:
                            $correctMethod = $item[$this->getData('name')];
                            break;
                    }
                    $item[$this->getData('name')] = $correctMethod;
                }
            }
        }
        return $dataSource;
    }

}
