define(
    [
        'Magento_Checkout/js/view/payment/default',
        'mage/url'
    ],
    function (Component,url) {
        'use strict';
        return Component.extend({
            defaults: {
                template: 'Toogas_Easypay/payment/easypay_boleto'
            },
            getMailingAddress: function () {
                return window.checkoutConfig.payment.checkmo.mailingAddress;
            },
            getInstructions: function () {
               return window.checkoutConfig.payment.instructions[this.item.method];
            },
            redirectAfterPlaceOrder: false,
            afterPlaceOrder: function () {
                window.location.replace(url.build('easypay/gateway/boletobancario'));
            },
            getPaymentLogoSrc: function () {
                return window.checkoutConfig.payment.images[this.item.method];
            }
        });
    }
);
