define(
    [
        'Magento_Checkout/js/view/payment/default',
        'jquery',
        'mage/url',
        'Magento_Customer/js/customer-data'
    ],
    function (Component, $, url, customerData) {
        'use strict';

        var customer_checkout_data = undefined;
        if(window.checkoutConfig.isCustomerLoggedIn && window.checkoutConfig.customerData.addresses.length > 0) {
            customer_checkout_data = window.checkoutConfig.customerData.addresses[0];
        }
        else {
            customer_checkout_data = customerData.get('checkout-data')().shippingAddressFromData;
        }

        let payment_methods = window.checkoutConfig.payment.subscriptions.list;

        //require('uiRegistry').get('checkout.steps.billing-step.payment.payments-list.easypay_frequent').selectedMethod;

        return Component.extend({
            defaults: {
                template: 'Toogas_Easypay/payment/easypay_frequent',
                paymentMethods: payment_methods,
                selectedMethod: payment_methods[0].code,
                phone: customer_checkout_data.telephone || '', //911234567 Aceite | 913456789 Recusado
                iban: '',
                account_holder: customer_checkout_data.firstname + ' ' + customer_checkout_data.lastname,
                tracks: {
                    selectedMethod: true
                }
            },
            getMailingAddress: function () {
                return window.checkoutConfig.payment.checkmo.mailingAddress;
            },
            getInstructions: function () {
                return window.checkoutConfig.payment.instructions[this.item.method];
            },
            setSelectedMethod: function(data, event) {
                this.selectedMethod = $.grep(this.paymentMethods, function(obj){return obj.code === event.target.value;})[0].code;
                this.redirectAfterPlaceOrder = this.selectedMethod !== 'cc';
            },
            getData: function () {
                return {
                    "method": this.item.method,
                    "additional_data": {
                        "payment_method": this.selectedMethod,
                        "phone_number": this.phone,
                        "iban": this.iban,
                        "account_holder": this.account_holder,
                    }
                };
            },
            redirectAfterPlaceOrder: true,
            afterPlaceOrder: function () {
                if(this.selectedMethod === 'cc') {
                    window.location.replace(url.build('easypay/gateway/creditcard') + '?f=1');
                }
            },
            getPaymentLogoSrc: function () {
                return window.checkoutConfig.payment.images[this.item.method];
            }
        });

    }
);
