define(
    [
        'Magento_Checkout/js/view/payment/default',
        'Magento_Customer/js/customer-data'
    ],
    function (Component, customerData) {
        'use strict';

        var customer_checkout_data = undefined;
        if(window.checkoutConfig.isCustomerLoggedIn && window.checkoutConfig.customerData.addresses.length > 0) {
            customer_checkout_data = window.checkoutConfig.customerData.addresses[0];
        }
        else {
            customer_checkout_data = customerData.get('checkout-data')().shippingAddressFromData;
        }

        return Component.extend({
            defaults: {
                template: 'Toogas_Easypay/payment/easypay_mbway',
                phone: customer_checkout_data.telephone || '' //911234567 Aceite | 913456789 Recusado
            },
            getMailingAddress: function () {
                return window.checkoutConfig.payment.checkmo.mailingAddress;
            },
            getInstructions: function () {
                return window.checkoutConfig.payment.instructions[this.item.method];
            },
            getData: function () {
                return {
                    "method": this.item.method,
                    "additional_data": {
                        "phone_number": this.phone
                    }
                };
            },
            placeOrder: function (data, event) {
                this._super();
            },
            getPaymentLogoSrc: function () {
                return window.checkoutConfig.payment.images[this.item.method];
            }
        });
    }
);
